/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingLists;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

class VWItemTypeListCellRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer {
    private VWMappingLists m_mappingLists = null;
    private JComboBox m_designerObjectComboBox = null;

    public VWItemTypeListCellRenderer(VWMappingLists mappingLists) {
        this.setOpaque(true);
        this.m_mappingLists = mappingLists;
    }

    public JComboBox getDesignerObjectComboBox() {
        try {
            if (this.m_designerObjectComboBox == null && this.m_mappingLists != null && this.m_mappingLists.getItemNames() != null) {
                this.m_designerObjectComboBox = new JComboBox<String>(this.m_mappingLists.getItemNames());
                this.m_designerObjectComboBox.setName("m_designerObjectComboBox_VWItemTypeListCellRenderer");
                DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.m_designerObjectComboBox.getModel();
                if (cbModel != null) {
                    cbModel.insertElementAt(VWResource.s_unmapped, 0);
                    cbModel.addElement(VWResource.s_nothing);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_designerObjectComboBox;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            if (value != null && value instanceof String) {
                this.setFont(list.getFont());
                this.setEnabled(list.isEnabled());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                String name = (String)value;
                this.setText(name);
                if (this.m_mappingLists != null) {
                    this.setIcon(this.m_mappingLists.lookupIcon(name));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            if (value != null && value instanceof String) {
                this.setFont(table.getFont());
                this.setEnabled(table.isEnabled());
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                } else {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
                String name = (String)value;
                this.setText(name);
                if (this.m_mappingLists != null) {
                    this.setIcon(this.m_mappingLists.lookupIcon(name));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

